******************************
* SET OPTIONS; SET LOCATIONS *
******************************
clear all
set trace off
set more off
global external_dir "D:\Dropbox\Michigan\RDC Project\AEJ Data Set\"			/*CHANGE THIS TO THE DIRECTORY THAT HAS THE FILES*/
global internal_dir "\projects\"											/*This is an internal RDC directory*/

capture log close


***************************************
* Migration flows by age: 2000 Census *
***************************************

*Bring in migration estimates by age from 2000 Census and separate them into bins
use "$internal_dir/data/Census 2000/census2000_flows_by_age.dta", clear
	egen id = group(country year)
	sort id
	
	*Estimates
	gen age_bin_0_12_Census = migs if age_a<=12
	gen age_bin_13_17_Census = migs if age_a>=13 & age_a<=17
	gen age_bin_18_24_Census = migs if age_a>=18 & age_a<=24
	gen age_bin_25_44_Census = migs if age_a>=25 & age_a<=44
	gen age_bin_45_64_Census = migs if age_a>=45 & age_a<=64
	gen age_bin_65p_Census = migs if age_a>=65
	
	collapse (sum) age_bin* , by(country year)
	
tempfile y2000
save `y2000', replace


*****************************************
* Migration flows by age: 2015-2015 ACS *
*****************************************

*Bring in migration estimates by age from ACS surveys and separate them into bins
forval y = 2005(1)2015 {
	use "$internal_dir/data/ACS `y'/acs`y'est_flows_by_age.dta"
	egen id = group(country year)
	sort id
	
	*Estimates
	gen age_bin_0_12`y' = migs if age_a<=12
	gen age_bin_13_17`y' = migs if age_a>=13 & age_a<=17
	gen age_bin_18_24`y' = migs if age_a>=18 & age_a<=24
	gen age_bin_25_44`y' = migs if age_a>=25 & age_a<=44
	gen age_bin_45_64`y' = migs if age_a>=45 & age_a<=64
	gen age_bin_65p`y' = migs if age_a>=65

	collapse (sum) age_bin* , by(country year)
	tempfile y`y'
	save `y`y'', replace
	}

	
********************
* Finalize aataset *
********************	

*Merge together and bring in stock data from Sample #1
use `y2000', clear
forval y = 2005(1)2015 {
	merge 1:1 country year using `y`y''
	drop _merge
	}
	
merge 1:1 country year using "$internal_dir/data/panel.dta"
drop _merge
sort country year

*Restrict years 
keep if year>=1980 & year<=2004

*Input zeroes when there are no sample observations for a country-year-age bin
local vars "bin_0_12 bin_13_17 bin_18_24 bin_25_44 bin_45_64 bin_65p"
foreach var in `vars' {
	replace age_`var'_Census = 0 if inflows!=. & age_`var'_Census==.
	forval y = 2005(1)2015 {
		replace age_`var'`y' = 0 if inflows!=. & age_`var'`y'==.
		}
	}

*Create outcomes and totals for disclosure analysis	
foreach var in `vars' {

	*Outcome numerator
	egen age_`var'_ACS = rowmean(age_`var'2005 age_`var'2006 age_`var'2007 age_`var'2008 ///
		age_`var'2009 age_`var'2010 age_`var'2011 age_`var'2012 ///
		age_`var'2013 age_`var'2014 age_`var'2015)
	drop age_`var'2005 age_`var'2006 age_`var'2007 age_`var'2008 ///
		age_`var'2009 age_`var'2010 age_`var'2011 age_`var'2012 ///
		age_`var'2013 age_`var'2014 age_`var'2015
	gen age_`var'_comb = age_`var'_ACS
	replace age_`var'_comb = age_`var'_Census if year<=1999
	
	}

	*Outcomes
	gen p_inflows = inflows/population1980
	foreach var in `vars' {
		gen p_`var'_comb = age_`var'_comb/population1980
		replace p_`var'_comb = 0 if p_inflows!=. & p_`var'_comb==.
		replace p_`var'_comb = . if p_inflows==. & p_`var'_comb!=.
		}

*Stock interaction variable
gen p_stock1980 = stock1980/population1980
drop if p_stock1980==.


***********
* Table 4 *
***********
cap erase "$internal_dir/output/table4.txt"
cap erase "$internal_dir/output/table4.rtf"
xtset country year
foreach var in `vars'  {	
	xtreg p_`var' i.year c.year#i.country HI, fe cl(country)
	outreg2 using "$internal_dir/output/table4", append word keep(HI) dec(4) nocons

	xtreg p_`var' i.year c.year#i.country HI c.HI#c.p_stock1980, fe cl(country)
	outreg2 using "$internal_dir/output/table4", append word keep(HI c.HI#c.p_stock1980) dec(4) nocons
	}

	
